 /*
AK Digital Clock & Digital Temperature and Humidity with PCF8563 & DHT11
*/ 
//فراخوانی کتابخوانه های لازم
#include <LiquidCrystal.h>
#include <PCF8563.h>
#include <TroykaDHT.h>
//تنظیم پین های نمایشگر LCD
LiquidCrystal lcd(8, 9, 4, 5, 6, 7);
//شروع ساعت دیجیتال
PCF8563 pcf;
//راه اندازی سنسور دماسنج و رطوبت سنج DHT روی پین 15 دیجیتال
DHT dht(15, DHT11);

 // در قسمت Setup مواردی را تعریف می کنیم که با شروع فعالیت برد نیامند آن ها هستیم. 
 void setup() {
  Serial.begin(9600);
  lcd.begin(16, 2);
  pcf.init();
  pcf.startClock();
  dht.begin();
}

 // در قسمت Loop مواردی را تعریف می کنیم که پس از شروع کار برد نیازمند تکرار آن ها هستیم. 
void loop() {
  lcd_print(); 
  serial_print(); 
  delay(1000);
}

//نمایش مقادیر ساعت دیجیتال و سنسور دیجیتال روی نمایشگر
void lcd_print() {
  //بازخوانی ساعت از ماژول ساعت دیجیتال
  Time nowTime = pcf.getTime();
  //شروع خط اول نمایشگر
  lcd.setCursor(0, 0);
  if (nowTime.day < 10) { lcd.print("0");  }
  //نمایش روز
  lcd.print(nowTime.day);
  lcd.print("/");
  if (nowTime.month < 10) { lcd.print("0");  }
  //نمایش ماه
  lcd.print(nowTime.month);
  lcd.print("/");
  lcd.print("20");
  //نمایش سال
  lcd.print(nowTime.year);
  lcd.print(" ");
  if (nowTime.hour < 10) { lcd.print("0");  }
  //نمایش ساعت
  lcd.print(nowTime.hour);
  lcd.print(":");
  if (nowTime.minute < 10) { lcd.print("0");  }
  //نمایش دقیقه
  lcd.print(nowTime.minute);
  //شروع خط دوم نمایشگر
  lcd.setCursor(0, 1);
  //بازخوانی دما و روطوب از سنسور DHT
  dht.read();
  lcd.print("Temp=");
  //نمایش دما
  lcd.print(dht.getTemperatureC(),0);
  lcd.print("\337");
  lcd.print("C Hu=");
  //نمایش رطوبت
  lcd.print(dht.getHumidity(),0);
  lcd.print("%");
}

//نمایش مقادیر ساعت دیجیتال و سنسور دیجیتال روی پورت سریال
void serial_print() {
  //بازخوانی ساعت از ماژول ساعت دیجیتال
  Time nowTime = pcf.getTime();
  //نمایش روز
  Serial.print(nowTime.day);
  Serial.print("/");
  //نمایش ماه
  Serial.print(nowTime.month);
  Serial.print("/");
  //نمایش سال
  Serial.print(nowTime.year);
  Serial.print(" ");
  //نمایش ساعت
  Serial.print(nowTime.hour);
  Serial.print(":");
  //نمایش دقیقه
  Serial.print(nowTime.minute);
  Serial.print(":");
  Serial.println(nowTime.second);
  //بازخوانی دما و روطوب از سنسور DHT
  dht.read();
  //نمایش دما
  Serial.print("Temperature = ");
  Serial.print(dht.getTemperatureC());
  Serial.print(" ");
  //نمایش رطوبت
  Serial.print("Humidity = ");
  Serial.print(dht.getHumidity());
  Serial.println(" %");
}

