/* 
  AK ESP8266 Pin Control
*/

#include <ESP8266WiFi.h>

// تنظیمات شبکه ی خود را در این قسمت وارد کنید.
const char* ssid =      "ssid";      //نام شبکه
const char* password =  "password";  //رمز شبکه

// تعریف پین LED
int ledPin = 12; // GPIO2
// تعریف اولین مقدار به صورت پیش فرض HIGH
int value = HIGH;

WiFiServer server(80);
 
void setup()
{
  delay(1000);
  Serial.begin(115200);

  // تعریف پین LED به صورت خروجی
  pinMode(ledPin, OUTPUT);
  // خاموش نگه داشتن LED پس از هر بار شروع مجدد برد
  digitalWrite(ledPin, HIGH);

  // در حال برقراری ارتباط با مودم یا روتر
  WiFi.begin(ssid, password);

  // نمایش وضعیت ارتباط
  Serial.println();
  Serial.print("Connecting");
  while (WiFi.status() != WL_CONNECTED)
  {
    delay(500);
    Serial.print(".");
  }
  // نمایش ارتباط موفقیت آمیز
  Serial.println("success!");

  // نمایش ایپی برد
  Serial.print("IP Address is: ");
  Serial.println(WiFi.localIP());

  // شروع سرور
  server.begin();
  Serial.println("Server started");
}

void loop() {
  // بررسی وضعیت بازدید کننده
  WiFiClient client = server.available();
  if (!client) {
    return;
  }
   
  // منتظر ارسال فرمان بازدید کننده
  Serial.println("new client");
  while(!client.available()){
    delay(1);
  }
   
  // خواندن اولین خط درخواست بازدید کننده
  String request = client.readStringUntil('\r');
  Serial.println(request);
  client.flush();
  
  // بررسی درخواست بازدید کننده
  // چنانچه در درخواست دریافت شده مقدار /LED=ON وجود داشت
  if (request.indexOf("/LED=ON") != -1) {
    // پین خروجی و مقدار داده را LOW کن
    digitalWrite(ledPin, LOW);
    value = LOW;
  }
  // چنانچه در درخواست دریافت شده مقدار /LED=OFF وجود داشت
  if (request.indexOf("/LED=OFF") != -1){
    // پین خروجی و مقدار داده را HIGH کن
    digitalWrite(ledPin, HIGH);
    value = HIGH;
  }
// Set ledPin according to the request
 //digitalWrite(ledPin, value);
  
  // ارسال پاسخ یا صفحه ی وب مورد نظر
  client.println("HTTP/1.1 200 OK");
  client.println("Content-Type: text/html");
  client.println("");
  client.println("<!DOCTYPE HTML>");
  client.println("<html>");
  //تنظیم نوشته در وسط صفحه
  client.println("<center>"); 
  // LED را روشن کن
  client.println("<a href=\"/LED=ON\">&#1585;&#1608;&#1588;&#1606; &#1705;&#1606;</a> - ");
  // LED را خاموش کن
  client.println("<a href=\"/LED=OFF\">&#1582;&#1575;&#1605;&#1608;&#1588; &#1705;&#1606;</a><br>");
  // ابوالفضل خزائی
  client.println("&#1575;&#1576;&#1608;&#1575;&#1604;&#1601;&#1590;&#1604; &#1582;&#1586;&#1575;&#1574;&#1740;"); 
  client.println("</center>"); 

  client.println("</html>");
 
  delay(1);
  // قطع ارتباط بازدید کننده
  Serial.println("Client disonnected");
  Serial.println("");
 
}
 
