/* 
  AK ESP8266 Temperature and Humidity
*/

#include <ESP8266WiFi.h>
#include <DHTesp.h>

DHTesp dht;

// تنظیمات شبکه ی خود را در این قسمت وارد کنید.
const char* ssid =      "ssid";      //نام شبکه
const char* password =  "password";  //رمز شبکه

WiFiServer server(80);

void setup()
{
  // شروع ارتباط سریال
  Serial.begin(115200);

  // تنظیم پین و نوع سنسور دما و رطوبت
  dht.setup(2, DHTesp::DHT11);
  
  // در حال برقراری ارتباط با مودم یا روتر
  WiFi.begin(ssid, password);

  // نمایش وضعیت ارتباط
  Serial.println();
  Serial.print("Connecting");
  while (WiFi.status() != WL_CONNECTED)
  {
    delay(500);
    Serial.print(".");
  }
  // نمایش ارتباط موفقیت آمیز
  Serial.println("success!");

  // نمایش ایپی برد
  Serial.print("IP Address is: ");
  Serial.println(WiFi.localIP());

  // شروع سرور
  server.begin();
  Serial.println("Server started");
}

void loop() {
  
  // بررسی وضعیت بازدید کننده
  WiFiClient client = server.available();
  if (!client) {
    return;
  }
   
  // منتظر ارسال فرمان بازدید کننده
  Serial.println("new client");
  while(!client.available()){
    delay(1);
  }
   
  // خواندن اولین خط درخواست بازدید کننده
  String request = client.readStringUntil('\r');
  Serial.println(request);
  client.flush();
   
  // ارسال پاسخ یا صفحه ی وب مورد نظر
  client.println("HTTP/1.1 200 OK");
  client.println("Content-Type: text/html");
  client.println("");
  client.println("<!DOCTYPE HTML>");
  client.println("<html>");
  //تنظیم نوشته در وسط صفحه
  client.println("<center><font dir='rtl'>");
  // نمایش میزان دما و رطوبت
  client.println("&#1583;&#1605;&#1575;: ");
  client.println(dht.getHumidity(), 2);
  client.println("C&#176; - &#1585;&#1591;&#1608;&#1576;&#1578;: ");
  client.println(dht.getTemperature(), 2);
  client.println("%<br>");
  // ابوالفضل خزائی
  client.println("&#1575;&#1576;&#1608;&#1575;&#1604;&#1601;&#1590;&#1604; &#1582;&#1586;&#1575;&#1574;&#1740;"); 
  client.println("</font></center>"); 

  client.println("</html>");
 
  delay(1);
  // قطع ارتباط بازدید کننده
  Serial.println("Client disonnected");
  Serial.println("");
}
 
